/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8230;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8230.DeviceView.Builder;
import ibm.nways.jdm8230.DeviceView.Chassis;
import ibm.nways.jdm8230.DeviceView.ChassisLike;
import ibm.nways.jdm8230.DeviceView.ChassisUnknown;
import ibm.nways.jdm8230.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8230.eui.FaultGroup;
import ibm.nways.jdm8230.eui.Jdm8230Group;
import ibm.nways.mib2.SystemGeneralGroup;
import ibm.nways.ras.RAS;
import ibm.nways.web.WebContext;
import java.applet.Applet;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;

public class Jdm8230
extends JdmBrowser {
    public static final Object[][] hub8230Overrides = new Object[][]{{"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}};
    private ChassisLike chassis;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private GenModel deviceModel;
    private ResourceBundle resBundle;
    private boolean isDeviceUp = false;
    public String sysOid;
    public String cauType;
    private Properties properties;

    public String getModelTypeName() {
        return "ibm.nways.jdm8230.model.Jdm8230";
    }

    public void dispose() {
        this.tree = null;
        this.rootFolder = null;
        this.deviceModel = null;
        this.resBundle = null;
        if (this.chassis != null) {
            this.chassis.dispose();
        }
        this.chassis = null;
        super.dispose();
    }

    public GraphicPanel getDeviceGraphicPanel() {
        if (RAS.isEnabled(19, 4)) {
            RAS.enter(19, 4, (Object)this, "getSeviceGraphicPanel");
        }
        long l = System.currentTimeMillis();
        this.chassis = Builder.getInstance().buildChassis(this);
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 4)) {
            RAS.trace(19, 4, (Object)this, "getSeviceGraphicPanel", "Time to build graphic objects -> " + (l2 - l));
        }
        l = System.currentTimeMillis();
        if (this.chassis != null) {
            this.chassis.draw();
        }
        l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 4)) {
            RAS.trace(19, 4, (Object)this, "getDeviceGraphicPanel", "Time to draw graphic objects  -> " + (l2 - l));
        }
        GraphicPanel graphicPanel = null;
        if (this.chassis != null) {
            graphicPanel = this.chassis.getGraphicPanel();
            if (this.chassis instanceof ChassisUnknown) {
                new WrongSysOidMsg(this.getFrame(), this.resBundle.getString("jdm8230"));
            }
        } else {
            new BoxDownMsg(this.getFrame(), this.resBundle.getString("jdm8230"));
        }
        if (RAS.isEnabled(19, 4)) {
            RAS.exit(19, 4, (Object)this, "getSeviceGraphicPanel");
        }
        return graphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        ModelInfo modelInfo;
        String string = ((Applet)((Object)this)).getParameter("trace_jma");
        Serializable serializable = null;
        Serializable serializable2 = null;
        if (string != null && string.equals("on")) {
            RAS.enableTrcLog(19, 4);
            RAS.trace(19, 4, (Object)this, "getNavTreeRoot", "Traces have been turned on");
        }
        this.deviceModel = (GenModel)this.getModel();
        this.resBundle = ResourceBundle.getBundle("ibm.nways.jdm8230.Resources");
        this.displayMsg(this.resBundle.getString("start"));
        try {
            modelInfo = this.deviceModel.getInfo("Config");
            serializable = modelInfo.get("Config.SysObjectID");
            serializable2 = modelInfo.get("Config.CauProdDataMachineType");
        }
        catch (Exception exception) {
            RAS.logException(19, 4, (Object)this, "getNavTreeRoot", exception);
        }
        if (serializable instanceof OID) {
            this.sysOid = serializable.toString();
            this.cauType = serializable2.toString();
            if (this.sysOid.equals("1.3.6.1.4.1.2.6.15")) {
                if (RAS.isEnabled(19, 4)) {
                    RAS.trace(19, 4, (Object)this, "getNavTreeRoot", "SysOid found:" + this.sysOid);
                }
                this.isDeviceUp = true;
            } else {
                if (RAS.isEnabled(19, 4)) {
                    RAS.trace(19, 4, (Object)this, "getNavTreeRoot", "Unknown 8230 Model");
                }
                this.isDeviceUp = false;
            }
        } else {
            if (RAS.isEnabled(19, 4)) {
                RAS.trace(19, 4, (Object)this, "getNavTreeRoot", "SysOid not found.");
            }
            this.isDeviceUp = false;
        }
        if (this.isDeviceUp) {
            this.rootFolder = new Jdm8230Group((JdmBrowser)this, this.deviceModel);
            modelInfo = this.rootFolder.getNavContext();
            new NavFieldOverride((NavigationContext)modelInfo, hub8230Overrides);
        } else {
            this.rootFolder = new NavigationFolder(this.resBundle.getString("Unknown_Chassis_Root_Folder"));
        }
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        this.displayMsg(this.resBundle.getString("start_rest"));
        NavigationFolder navigationFolder = (NavigationFolder)this.getNavigationTree();
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.rootFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        this.buildConfigurationFolder(navigationFolder);
        this.buildFaultFolder(navigationFolder);
        this.buildToolsFolder(navigationFolder);
        this.displayMsg(this.resBundle.getString("done"));
        if (this.chassis != null) {
            ((Chassis)this.chassis).startStatusThread((Chassis)this.chassis);
            ((Chassis)this.chassis).startMACAddressThread((Chassis)this.chassis);
        }
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 4, (Object)this, "buildConfigurationFolder", exception);
        }
        if (genModel == null || !this.isDeviceUp) {
            GenModel genModel2 = null;
            try {
                genModel2 = (GenModel)this.deviceModel.getComponent("System");
            }
            catch (Exception exception) {
                RAS.logException(19, 4, (Object)this, "buildConfigurationFolder", exception);
            }
            if (genModel2 != null) {
                SystemGeneralGroup systemGeneralGroup = new SystemGeneralGroup((JdmBrowser)this, genModel2);
                systemGeneralGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)systemGeneralGroup);
                navigationFolder.add((NavigationPoint)systemGeneralGroup);
                return;
            }
        } else {
            ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
            configurationFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
            navigationFolder.add((NavigationPoint)configurationFolderGroup);
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Traps");
        }
        catch (Exception exception) {
            RAS.logException(19, 4, (Object)this, "buildFaultFolder", exception);
        }
        if (genModel != null) {
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, this.deviceModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(this.resBundle.getString("fault"), (NavigationDestination)new MessageDestination(this.resBundle.getString("NotConfigured"))));
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        WebContext webContext;
        ModelInfo modelInfo;
        SnmpContextModel snmpContextModel;
        NavigationFolder navigationFolder2 = new NavigationFolder(this.resBundle.getString("ToolsFolder"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            NavigationContext navigationContext;
            ResourceBundle resourceBundle;
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            if (this.getIsApplication()) {
                webContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                resourceBundle = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = resourceBundle.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)webContext);
                navigationFolder2.add((NavigationPoint)resourceBundle);
            }
            webContext = new WebContext(string);
            resourceBundle = ResourceBundle.getBundle("ibm.nways.web.Resources");
            webContext.only_nhd_url();
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
        }
        catch (Exception exception) {
            RAS.logException(19, 4, (Object)this, "buildToolsFolder", exception);
        }
        try {
            modelInfo = this.getNavigationBrowser();
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            webContext = new Browser("MIB Browser", (JdmBrowser)this, snmpContextModel);
            modelInfo.addEventListener((NavigationBrowserEventListener)webContext);
            navigationFolder2.add((NavigationPoint)webContext.getRootFolder());
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 4, (Object)this, "buildToolsFolder", exception);
            return;
        }
    }

    public Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        try {
            URL uRL = new URL(((Applet)((Object)this)).getDocumentBase(), "properties/Jdm8230.txt");
            Properties properties = new Properties();
            properties.load(uRL.openStream());
            this.properties = properties;
            return properties;
        }
        catch (Exception exception) {
            RAS.logException(19, 4, (Object)this, "getProperties", exception);
            return null;
        }
    }
}

